import pandas as pd
from datetime import datetime
from docxtpl import DocxTemplate
import os
import sys

# --- BLOQUE PARA GESTIONAR RUTAS EN WINDOWS ---
# Esto asegura que el script encuentre los archivos Excel/Word 
# sin importar desde dónde lo ejecute el programador de tareas.
if getattr(sys, 'frozen', False):
    application_path = os.path.dirname(sys.executable)
else:
    application_path = os.path.dirname(os.path.abspath(__file__))

# Definimos las rutas completas
ruta_template = os.path.join(application_path, "auto1.docx")
ruta_excel = os.path.join(application_path, "auto1.xlsx")
# ----------------------------------------------

print(f"Buscando archivos en: {application_path}")

# Cargar la plantilla usando la ruta completa
try:
    doc = DocxTemplate(ruta_template)
except FileNotFoundError:
    print("Error: No se encuentra el archivo auto1.docx")
    exit()

nombre = "Profesor Rosa"
telefono = "(56) 987654321"
correo = "rosa@guruguru.cl"
fecha = datetime.today().strftime("%d/%m/%y")

print(f"Fecha de ejecución: {fecha}")

constantes = {"nombre" : nombre, "telefono" : telefono, "correo" : correo, "fecha" : fecha}
print("Datos del profesor:", constantes)

doc.render(constantes)

# Cargar el excel usando la ruta completa
try:
    df = pd.read_excel(ruta_excel)
except FileNotFoundError:
    print("Error: No se encuentra el archivo auto1.xlsx")
    exit()

for indice, fila in df.iterrows():
    contenido = {
        "alumno" : fila["alumno"],
        "matematica": fila["matematica"],
        "fisica": fila["fisica"],
        "quimica": fila["quimica"]
    }
    contenido.update(constantes)

    doc.render(contenido)
    
    # Guardamos el resultado también en la misma carpeta
    nombre_archivo = f"Notas_de_{fila['alumno']}.docx"
    ruta_salida = os.path.join(application_path, nombre_archivo)
    
    doc.save(ruta_salida)
    print(f"Generado: {nombre_archivo}")

print("--- Proceso Finalizado ---")